set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 8, estimates using patent counts

**1. Preparing data
use $path_in\KLEMS_b2008_pat_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*Define patent counts variable
	gen lnpat_usnonus=lnpat_nonusinv if country=="USA"
	replace lnpat_usnonus=lnpat_usinv if country!="USA"
	
	*Set productivity measure as patent counts
	local LP lnpat_usnonus
	
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP
		replace D1_LP1_EMP=. if D1_lnTFPva_oth==. /*set patents to missing if leave-out TFP not observed for that country*/

	*Standardizing patenting variable
	drop if D1_LP1_EMP==.
	foreach var in D1_LP1_EMP {
		sum `var' [w=weight_VA_c]
		gen temp`var'=r(sd)
		replace `var'=`var'/temp`var'
		drop temp`var'
	}	
	
	egen ct=group(country year)
	egen ic=group(code country)
	egen it=group(code year)

save $path_temp\temp_T8, replace

		
**2. T8, top panel
use $path_temp\temp_T8, clear
	
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T8_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
	end		
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local controls1	""
	local controls2	"i.country*year i.country*i.bcycle"
	local controls3	""
	
	**Column A: Employment
		global col=1
		qui xi:areg D1_lnEMP  `own' `controls1' [w=weight_c], absorb(country) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnEMP  `own' `controls2' [w=weight_c], absorb(year) clus(ic) 
			storeestimates
		global col=3
		qui xi:areg D1_lnEMP  `own' `controls3' [w=weight_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column B: Hours worked
		global col=4
		qui xi:areg D1_lnH_EMP  `own' `controls1' [w=weight_h_c], absorb(country) clus(ic) 
			storeestimates
		global col=5
		qui xi:areg D1_lnH_EMP  `own' `controls2' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnH_EMP  `own' `controls3' [w=weight_h_c], absorb(ct) clus(ic)
			storeestimates

	**Column C: Nominal wage bill
		global col=7
		qui xi:areg D1_lnLAB  `own' `controls1' [w=weight_h_c], absorb(country) clus(ic) 
			storeestimates
		global col=8
		qui xi:areg D1_lnLAB  `own' `controls2' [w=weight_h_c], absorb(year) clus(ic) 
			storeestimates
		global col=9
		qui xi:areg D1_lnLAB  `own'  `controls3' [w=weight_h_c], absorb(ct) clus(ic) 
			storeestimates

	
	*Table
	esttab T8_1 T8_2 T8_3 T8_4 T8_5 T8_6 T8_7 T8_8 T8_9 , keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 8, top panel")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6 `var'_7 `var'_8 `var'_9, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 8, top panel")
		}	
			

**3. T8, bottom panel
use $path_temp\temp_T8, clear
	
	tsset cross year
	
	cap program drop storeestimates
	program define storeestimates
				est store T8_$col
				lincomest D1_LP1_EMP + L.D1_LP1_EMP + L2.D1_LP1_EMP + L3.D1_LP1_EMP + L4.D1_LP1_EMP + L5.D1_LP1_EMP
				estimates store own_$col
	end		
		
	local own 		"D1_LP1_EMP L.D1_LP1_EMP L2.D1_LP1_EMP L3.D1_LP1_EMP L4.D1_LP1_EMP L5.D1_LP1_EMP"
	local controls1	""
	local controls2	"i.country*year i.country*i.bcycle"
	local controls3	""

	**Column D: Nominal value added
		global col=1
		qui xi:areg D1_lnVA  `own' `controls1' [w=weight_VA_c], absorb(country) clus(ic) 
			storeestimates
		global col=2
		qui xi:areg D1_lnVA  `own' `controls2' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=3
		qui xi:areg D1_lnVA  `own' `controls3' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
	**Column E: Real value added
		global col=4
		qui xi:areg D1_lnVA_QI  `own' `controls1' [w=weight_VA_c], absorb(country) clus(ic) 
			storeestimates
		global col=5
		qui xi:areg D1_lnVA_QI  `own' `controls2' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=6
		qui xi:areg D1_lnVA_QI  `own' `controls3' [w=weight_VA_c], absorb(ct) clus(ic)
			storeestimates

	**Column F: Laborshare
		global col=7
		qui xi:areg D1_lnlaborshare  `own' `controls1' [w=weight_VA_c], absorb(country) clus(ic) 
			storeestimates
		global col=8
		qui xi:areg D1_lnlaborshare  `own' `controls2' [w=weight_VA_c], absorb(year) clus(ic) 
			storeestimates
		global col=9
		qui xi:areg D1_lnlaborshare  `own' `controls3' [w=weight_VA_c], absorb(ct) clus(ic) 
			storeestimates
			
	
	*Table
	esttab T8_1 T8_2 T8_3 T8_4 T8_5 T8_6 T8_7 T8_8 T8_9, keep(`own') order(`own') b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 8, bottom panel")
	
	foreach var in own  {
		dis "												`var' effects"
			esttab `var'_1 `var'_2 `var'_3 `var'_4 `var'_5 `var'_6 `var'_7 `var'_8 `var'_9, b(3) se(3) r2(3) stats(r2 N) se star(~ 0.10 * 0.05 ** 0.01) addnotes("Table 8, bottom panel")
		}	
			

*erase temporary file
erase $path_temp\temp_T8.dta			
